#!/usr/bin/python 
# -*- coding: Latin1 -*- 
#
# miniServer.pyw, einfacher WebServer
# Version 0.08, 2005-10-19
# Changes:
#    0.07:  konsequent objektorientiert!
#           neue Klasse myApp mit Widgets
#    0.08:  Kommentare fr pydoc
#           Test: pydoc -w ./miniServer.pyw
#           Ergebnis: die Datei miniServer.html
# W. Spiegel, walter.spiegel@web.de
# Grenzen: unter Windows muss die betreffende
# IP/Netzwerkkarte aktiv sein!!
###################################
import thread, os
from socket import *
import string
from os.path import abspath,exists,isdir
from SimpleHTTPServer import SimpleHTTPRequestHandler
import SocketServer

import Tkinter
if os.name == 'posix':
    Tkinter.wantobjects = 0
    # tkMessageBox.askyesno wrong result under Linux!
    # see http://mail.python.org/pipermail/python-bugs-list/2004-September/025172.html

from Tkinter import *
from ScrolledText import *
import tkMessageBox, tkSimpleDialog, tkDirectoryChooser
###################################
idle = 0
###################################
vers = "0.08"
date = "2005-10-19"
###################################
home_dir = os.getcwd()
home_dir = os.path.abspath(home_dir)

## globale Variablen
old_stderr = sys.stderr

root = Tk()
root.title('miniServer, ' + vers)

app = None

##################################
## font and font-size
ccFontArt='normal'
ccFontType='courier'
if os.name == 'posix':
    ccFontSize=12
else:    
    ##ccFontType='systemfixed'    
    ccFontSize=10
ccFont=(ccFontType,ccFontSize,ccFontArt)    
##################################
def myPrint(s):
    """Ruft die stderr-Ausgabe auf"""
    sys.stderr.write( s )
    
def dateiLesen (datei): 
    """liest eine Datei, gibt Inhalt als
       Liste zurueck, falls erfolgreich, sonst []
    """ 
    try:        
        in_file = open(home_dir + os.sep + datei,"r") 
        # Datei zum Lesen (r: read) oeffnen 
    except IOError: 
        #in_file.close() # Datei schliessen
        return []
    else: 
        liste = in_file.readlines() # Datei lesen 
        in_file.close() # Datei schliessen 
        return liste 

def grenzTest(wert, unten,oben):
    """Testet ob 'wert' zwischen 'unten' und 'oben' liegt.
    """    
    if (wert >= unten) and (wert <= oben):
        return 1  ## true oder wahr
    else:
        return 0  ## false oder falsch


def ende():
    """Beendet den miniServer
    """
    if tkMessageBox.askyesno('BeEnDeN?','miniServer beenden?'):
        sys.stderr = old_stderr
        if app.miniServer:
            try:
                app.miniServer.stop() 
            except SystemExit:
                pass        
        root.destroy()




##################################
class WebServer:
    """Benutzt den SimpleHTTPRequestHandler,
       setzt auf der TCP/IP-Socket-Schnittstelle auf.
    """

    def __init__(self,vers,date):
        """Initialisierung des Startverzeichnisses, TCP/IP,
           Port, Konfigurationsdatei, Version, Datum,
           Server und run-Flag
        """
        if os.name == 'posix':
            self.webVerzeichnis = "/home/walter/homepage"
            self.TCP_IP = "192.168.1.107"
        else: # win_xx
            self.webVerzeichnis = "F:/homepage"
            self.TCP_IP = "127.0.0.1"
        
        self.PORT = 8080  # port 80 requires root-privilegies 

        self.confi = 'httpd.conf'
	
        self.vers = vers
	
        self.date = date	

        self.serv = None

        self.run = 0	


    def leseConfi(self):
        """Liest die Konfigurationsdatei self.confi
           leseConfi legt fest:
           "startverzeichnis": self.webVerzeichnis
           "ip": self.TCP_IP        
           "port": self.PORT
        """
        _debug_ = 0
        liste = []
        if os.name == 'posix':
            confi_ = 'linux' + os.sep + self.confi
        else:
            confi_ = 'win' + os.sep + self.confi
        liste = dateiLesen(confi_)
        if (liste != []):
            for element in liste:
                if (element.find('#') == -1):                    
                    if len( element ) > 0:
                        
                        if (element.find('startverzeichnis') != -1):
                            j = liste.index(element)
                            self.webVerzeichnis = abspath(string.strip(liste[j+1]))
                            if _debug_:
                                print string.strip(liste[j+1])
                            
                        if (element.find('ip') != -1):
                            j = liste.index(element)
                            self.TCP_IP = str( string.strip(liste[j+1]) )
                            if _debug_:
                                print str(string.strip(liste[j+1]))
            
                        if (element.find('port') != -1):
                            j = liste.index(element)
                            self.PORT = int(liste[j+1])
                            if _debug_:
                                print string.strip(liste[j+1])
                        
                        
        else:
            myPrint( "Lesen der Config-Datei '" + self.confi + "' fehlgeschlagen!\n" )
            myPrint( "Benutze Default-Einstellungen!\n" )


    def status(self):
        """Gibt den Status des MiniWebServers aus"""
        myPrint( '\nminiWebServer, Status:\n' )
        myPrint( 'Startverzeichnis: ' + self.webVerzeichnis + '\n' )
        myPrint( 'IP: ' + self.TCP_IP  + '\n' )
        myPrint( 'Port: ' +  str(self.PORT) + '\n' )
        if self.run:
            myPrint(  'miniWebServer is running!\n')



    def start(self):
        """Startet den miniWebServer: der Server ist
           ein TCP-SocketServer, der Handler ist ein
           SimpleHTTPRequestHandler.
        """
        _verbose_ = 0
        if exists(self.webVerzeichnis):  # alternativ: isdir(Server.webVerzeichnis)
            # Wechsle ins Dokument-Wurzelverzeichnis.
            os.chdir(self.webVerzeichnis)
            #myPrint( self.webVerzeichnis )            
            try:
                # Starte den SimpleHTTP-Server
                ##serv = HTTPServer(("", PORT), SimpleHTTPRequestHandler)
                Handler = SimpleHTTPRequestHandler
                if _verbose_:
                    self.status()                
                myPrint('Starte Server auf ' + self.TCP_IP  + ':' + str(self.PORT) + '\n')                
                self.serv = SocketServer.TCPServer((self.TCP_IP,self.PORT ), Handler)
                self.run = 1
                self.serv.serve_forever()            
            except (IOError, RuntimeError):
                myPrint( "Fehler beim Starten des Web-Servers!\n" )
        else:
            myPrint( "Verzeichnis " + self.webVerzeichnis + " nicht gefunden!\n" )


    def stop(self):
        """Beendet den TCP-SocketServer, indem der
           Socket geschlossen wird.
        """
        if self.serv:  #             
            #myPrint(str( self.serv.socket ) )
            try: 
                self.serv.socket.close()
                self.run = 0
            except:
                myPrint( "Fehler beim Herunterfahren des miniServers!\n" )

##################################
class Redirect:
    """Umlenkung der Standardfehlerausgabe stderr
       Idee aus F. Lundh: Python Standard Bibliothek, S. 54/55
    """    

    def __init__(self,stderr):
        """Umlenkung der Standardfehlerausgabe stderr"""
        self.stderr = stderr

    def write(self,s):
        """berschreibt die write-Methode;
           schreibt in das Textfenster der Anwendung app
           Die Anwendung app muss das Tkinter-Objekt
           textfenster zur Verfgung stellen!
        """
        app.textfenster.insert(END, s)
        app.textfenster.yview(END) 


##################################
class einstellungenfenster(tkSimpleDialog.Dialog): 
    """Die Klasse 'einstellungenfenster' ist abgeleitet aus tkSimpleDialog
       Aufruf: einstellungen_ = einstellungenfenster(root)
    """
    def body(self, master):
        
        adr_list = string.split(app.miniServer.TCP_IP,'.')    ## TCP/IP-Adresse aufteilen        

        self.title('Einstellungen')        

        Label(master, text='Port:   ',font=ccFont,anchor=W).grid(row=0) 
        Label(master, text='TCP/IP: ',font=ccFont,anchor=W).grid(row=1)
        if os.name == 'posix': 
            self.e1 = Entry(master,width=19,font=ccFont)
        else: ## windows!
            self.e1 = Entry(master,width=18,font=ccFont)
            
        self.e1.insert('0',app.miniServer.PORT)

        self.tcp = Frame(master)        

        self.e2 = Entry(self.tcp,width=4,font=ccFont) 
        self.e3 = Entry(self.tcp,width=4,font=ccFont) 
        self.e4 = Entry(self.tcp,width=4,font=ccFont) 
        self.e5 = Entry(self.tcp,width=4,font=ccFont)

        self.e2.insert('0',adr_list[0])
        self.e3.insert('0',adr_list[1])
        self.e4.insert('0',adr_list[2])
        self.e5.insert('0',adr_list[3])

        self.e1.grid(row=0, column=1)        
        self.tcp.grid(row=1, column=1)
        
        self.e2.pack(side=LEFT) 
        self.e3.pack(side=LEFT) 
        self.e4.pack(side=LEFT) 
        self.e5.pack(side=LEFT) 

        return self.e1 # initial focus 
        
 
    def apply(self): 
        self.a1 = self.e1.get()
        self.a2 = self.e2.get()
        self.a3 = self.e3.get()        
        self.a4 = self.e4.get()        
        self.a5 = self.e5.get()
        
        self.result = 1 


##################################

class myApp:   
    def __init__(self, master=None):
        """Legt das MiniWebServer-TK-Fenster fest
        """
        
        self.root = master
        
        self.fpopup = Frame(self.root,width=500) 
        self.fpopup.pack(expand=1, fill=BOTH) 
         
        self.popup = Menu(self.fpopup,tearoff=0)
        self.popup.add_command(label='Einstellungen', command=self.einstellungen)
        self.popup.add_separator()
        self.popup.add_command(label='Status', command=self.status)        
        self.popup.add_separator()
        self.popup.add_command(label='Info', command=self.info)
        self.popup.add_separator()
        self.popup.add_command(label='Beenden', command=ende)


        self.textfenster = ScrolledText(self.fpopup,width=90,height=24,background='white')
        self.textfenster.pack(fill=BOTH,expand=YES)

        ## Bindings . . .
        self.textfenster.bind('<Alt-F4>',self.ende_)
        self.textfenster.bind('<Button-3>',self.popup_)
        
        ## Buttons    
        self.but2 = Button(self.fpopup,text='Einstellungen', command = self.einstellungen)
        self.but2.pack(side = LEFT,fill=BOTH,expand=YES)

        self.but6 = Button(self.fpopup,text='Startverzeichnis', command = self.startverzeichnis)
        self.but6.pack(side = LEFT,fill=BOTH,expand=YES)

        self.but5 = Button(self.fpopup,text='Status', command = self.status)
        self.but5.pack(side = LEFT,fill=BOTH,expand=YES)
        
        self.but1 = Button(self.fpopup,text='Start', command = self.start)
        self.but1.pack(side = LEFT,fill=BOTH,expand=YES)

        self.but4 = Button(self.fpopup,text='Stop', command = self.stop)
        self.but4.pack(side = LEFT,fill=BOTH,expand=YES)

        self.but3 = Button(self.fpopup,text='Beenden', command = ende)
        self.but3.pack(side = LEFT,fill=BOTH,expand=YES)
        
        ## miniServer starten!
        self.miniServer = WebServer(vers,date)
        self.miniServer.leseConfi()
        

    
    def einstellungen(self):
        """ffnet das Einstellungenfenster fr Port und IP"""
        einstellungen_ = einstellungenfenster(self.root)
        if einstellungen_.result <> None:
            z1 = int(einstellungen_.a1)
            if grenzTest(z1,512,65536):
                self.miniServer.PORT = z1
            z2 = int(einstellungen_.a2)
            z3 = int(einstellungen_.a3)
            z4 = int(einstellungen_.a4)
            z5 = int(einstellungen_.a5)        
            if grenzTest(z2,0,255) and grenzTest(z3,0,255) and grenzTest(z4,0,255) and grenzTest(z5,0,255) :
                self.miniServer.TCP_IP = str(z2) + '.' + str(z3) + '.' + str(z4) + '.' + str(z5)   ## TCP/IP-Adresse basteln

                   
    def info(self): 
        """Info (Who's who . . .)""" 
        tkMessageBox.showinfo("Info",                    
            "miniServer by W. Spiegel\n" +
            "Vers. " + vers + ", " + date) 


    def stop(self):
        """Stoppt den MiniWebServer
        """
        if self.miniServer.run:
            try:
                self.miniServer.stop()    
                myPrint('miniWebServer gestoppt!')
            except SystemExit:
                myPrint('Kein Erfolg! miniWebServer nicht zu stoppen . . .')

               

    def status(self):
        """Gibt den Status des MiniWebServers aus
        """        
        self.miniServer.status()

    def startverzeichnis(self):
        """Auswahl des Startverzeichnisses
        """        
        start_pfad = self.miniServer.webVerzeichnis
        #myPrint(start_pfad + '\n')
        verzeichnis = tkDirectoryChooser.askdirectory(title='Choose Directory',initialdir=start_pfad,parent=root)
        if len(verzeichnis) > 0: # !!!
            verzeichnis = os.path.abspath( verzeichnis )
            if exists(verzeichnis):
                self.miniServer.webVerzeichnis = verzeichnis
                #myPrint(verzeichnis + '\n')


    def start(self):
        """Startet den MiniWebServer als neuen Thread
        """        
        thread.start_new_thread(self.miniServer.start,() )

    def ende_(self,event):
        """Beendet den MiniWebServer
        """
        ende()

    def popup_(self,event):
        """Ereignis-Methode fr das Popup-Fenster
        """        
        self.popup.post(event.x_root, event.y_root) 




############################
## MAIN - Hauptprogramm
############################
if  __name__ == '__main__':

    sys.stderr = Redirect(sys.stderr)
    
    root.protocol('WM_DELETE_WINDOW',ende)
    
    app = myApp(root)
                
    ## los gehts
    if not idle:
        root.mainloop()







































