md2reveal
=====


###  md2reveal

`md2reveal` converts a markdown based slide into a html-presentation for **[reveal.js](http://lab.hakim.se/reveal-js/#/)**, which is a HTML Presentation Framework from Hakim El Hattab.

---

### Screenshot

![](./md2reveal.png)

|||

### HowTo 

* **IN**: the markdown file **`Markdown in`** and the menu/mathjax - checkbutton

* **OUT**: the HTML-file **`HTML out`** will be generated using the template file **`md2reval.temp`** in the subdirectory **`template`**.

* **\_in2out\_**: takeover the **`Markdown in`** file name for the **`HTML out`** file name. The extension will be **`*.html`**.

|||

### Markdown - Extensions for slides

*  **`---`** &nbsp; &rarr;  three dashes to separate slides  
*  **`.notes:`**  for Notes  (in front the period and including the colon!)
*  **`|||`** &nbsp; &rarr;  three vertical bars as a vertical seperator (<br />**Note:** The vertical seperator must be in **front of the slide**, where the vertical branching started. Use the normal seperator (&rarr; three dashes), and the branching stops hopefully . . .
* Underline with three equals **===** for the title of the presentation (&rarr; `title-tag`)


|||

### `config.json`

You can edit and change the markdown extensions configuration in the JSON-file **`config.json`**


---

### Checkbuttons

* **MathJax**: Support for MathJax (&rarr; LaTeX-like Math-Formula).
    * **Note**: The Download of `MathJax.js` increases the load time.

* **Menu**: Support for [reveal.js-menu](https://github.com/denehyg/reveal.js-menu), which is a nice Add-On for [reveal.js](http://lab.hakim.se/reveal-js/#/).

---

### Notes &rarr; 1

* Without [reveal.js](http://lab.hakim.se/reveal-js/#/) the slide is a little bit ugly!

* The path to [reveal.js](http://lab.hakim.se/reveal-js/#/) in the generated HTML-file `HTML out` reflects my own installation. You should fix it to your own needs.

* The [reveal.js-menu](https://github.com/denehyg/reveal.js-menu) is from Greg Denehy. It must be installed separately.

---

### Notes &rarr; 2

* The proper use of `md2reveal` is based on the [Python-Markdown](https://pythonhosted.org/Markdown/) module, which has to be installed first. [Python-Markdown](https://pythonhosted.org/Markdown/) is a Python implementation of John Gruber’s [Markdown](http://daringfireball.net/projects/markdown/).

* `md2reveal` is a **[python 2.7.x](https://www.python.org/download/releases/2.7/)**-script . . .


---

### License

Copyright (C) 2017 Walter Spiegel

<small>Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:</small>

<small>The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.</small>

<small>THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.</small>

---

### About

&rarr; sp, 2017-01-26, Vers. 009

<small>Mail: `walter [dot] spiegel [at] web [dot] de`</small>
