Reveal - Tutor
=====

### Reveal - Tutor

  * Powered by [Reveal.js](http://lab.hakim.se/reveal-js/#/)  
The HTML Presentation Framework

  * Menu from [reveal.js-menu](https://github.com/denehyg/reveal.js-menu)
  * &rarr; Ende 

|||

### Aufbau der Präsentation I

Die Seiten der Präsentation kommen nach dem `<div>`-Tag:

    
    
    		<div  class="slides">
    			Hier die Präsentation erstellen in HTML oder via Markdown
    		</div>

|||    						

### Aufbau der Präsentation II

Jede Folie wird durch das `<section>`-Tag eingeklammert:

    
    
    	<section>
    		Hier entsteht eine Folie :-)
    	</section>
    					
---

### HowTo

Einfach im HTML-Quellcode der Seite nachschauen . . .

&rarr; Retour zur Startseite 

Im Quellcode:

    
    
    	<a href="#/0">
    		&rarr; Retour zur Startseite
    	</a>

---    					

### Verzögerungen . . .

Mit Verzögerung: simple Text

HowTo:

    
    
    	<div class="fragment">
    		Mit Verzögerung: simple Text . . .
    	</div>

|||    					

### Springen zwischen den Folien I

  1. Die Folien sind durchnummeriert, beginnend bei 0
  2. Die Folien können mit einer ID versehen werden
  3. Beispiel: Zur letzten Folie
    
    
    	<a href="#/last-slide">
    		Zur letzten Folie
    	</a>

|||    					

### Springen zwischen den Folien II

Auf der letzten Folie befindet sich unter `section` die entsprechende `id`:

    
    
    	<section id="last-slide">
    					
-|-

### Vertikale Folien I

Neben der _horizontalen_ Anordnung lassen sich Folien auch _vertikal_
anordnen.

![](overview.png)

|||

### Vertikale Folien II

Im Quellcode innerhalb einer `<section>` eine weitere `<section>` einbetten:

    
    
    <section>
    	<section>
    		&rarr; Quellcode Verzweigungen . . .
    	</section>
    </section>
    					
-|- 


### Folien-Übergang

**Beachte** die vertikale Folie ↘

&rarr; Oder benutze das **Menu** links unten. &larr;

|||

### Folien-Übergang: concave

|||

### Folien-Übergang: convex-in fade-out

|||

### Folien-Übergang: none

Im Quellcode:

    
    
    	<section data-transition="none">
    		&rarr; Quellcode Folien-Übergang
    	</section>
   
 
-|-

### Tastatur - Codes I

&rarr; `ESC`-Taste: Übersichtsmodus

alternativ: `o`-Taste

|||

### Tastatur - Codes II

|  `f`-Taste  | Fullscreen-Mode  |
| ----------- | --------------- |
| `Leertaste` <br />alternativ | nächste Folie <br />`n`-Taste     |
| `p`-Taste   | vorherige Folie |
| `m`-Taste   | Menü      |
| `b`-Taste <br />alternativ | Schwarzer Bildschirm <br /> `.`-Taste |

|||

### Tastatur - Codes III

Pfeil-Tasten &rarr; `↓ ↑` &larr; : Navigation innerhalb der Präsentation

|||

### Tastatur - Codes IV

[Keyboard Shortcuts](https://github.com/hakimel/reveal.js/wiki/Keyboard-
Shortcuts)

---

### Mathematik

Einbindung via **MathJax**

    
    
    math: {
    	// mathjax: 'http://cdn.mathjax.org/mathjax/latest/MathJax.js',
    					config: 'TeX-AMS_HTML-full'
    },
    
    dependencies: [
    	{ src: '../../lib/js/classList.js' },
    	{ src: '../../plugin/math/math.js', async: true }
    ]
    

Beispiel: [Quotientenregel](./mathematik_beispiel.html)

|||

### Markdown-Syntax I

Beispiel: [HvGG-Methodentage 2015](./methodentage_2015.html)

    
    
    <section  data-markdown>
    	<script type="text/template">
    		### Markdown-Syntax!
    		* Beispiel: **„Text formatieren"**
    	</script>
    </section>
    				
|||

### Markdown-Syntax II

Am Ende der Seite das **Plugin** einbinden

    
    
    // Optional reveal.js plugins
    dependencies: [
    	{ src: 'plugin/markdown/marked.js', condition: function() { return !!document.querySelector( '[data-markdown]' ); } },
    	{ src: 'plugin/markdown/markdown.js', condition: function() { return !!document.querySelector( '[data-markdown]' ); } },
    ]

  
-|-

### PDF-Export I

in den Kopf (&rarr; `head`) der HTML-Datei:

    
    
    <script>
    	
    	var link = document.createElement( 'link' );
    	link.rel = 'stylesheet';
    	link.type = 'text/css';
    	link.href = window.location.search.match( /print-pdf/gi ) ? 'css/print/pdf.css' : 'css/print/paper.css';
    	document.getElementsByTagName( 'head' )[0].appendChild( link );
    	
    </script>
    				
|||

### PDF-Export II

Aufruf im Browser: `mein_verzeichnis/reveal_tutor.html?print-pdf`

  1. Aus dem Browser heraus in den Drucken-Dialog
  2. Als Ziel `Drucken in Datei` wählen
  3. Einstellungen: _Skalierung 100%; Querformat_

|||

### PDF-Export III

Druckvorschau:

![](druckvorschau_reveal2pdf.png)

&rarr; [Ergebnis](./reveal_tutor.pdf)

---

### Links

  * [Reveal.js](http://lab.hakim.se/reveal-js/#/) (extern)
  * [Download](https://github.com/hakimel/reveal.js/) via Github
  * [Slide-Backgrounds](./beispiele/examples/slide-backgrounds.html)
  * [Sonderzeichen in HTML](https://wiki.selfhtml.org/wiki/Referenz:HTML/Zeichenreferenz)

---

### Tutorials

  * [Reveal.js for Beginners](http://htmlcheats.com/reveal-js/reveal-js-tutorial-reveal-js-for-beginners/) by Tom Campbell 
  * [Präsentationen mit reveal.js](http://nicobruenjes.de/2014/07/praesentationen-mit-reveal-js/) von Nico Brünjes 
  * [Presentations With Reveal.js and HTML5: Better Than PowerPoint](http://www.noupe.com/development/presentations-with-reveal-js-html5-better-than-powerpoint-72609.html) by Denis Potschien (auf [Deutsch](http://www.drweb.de/magazin/powerpoint-vs-html5-praesentationen-mit-reveal-js-35807/)) 
  * [Example Presentations](https://github.com/hakimel/reveal.js/wiki/Example-Presentations)
  * [Teaching with open source presentation service Reveal.js](http://opensource.com/education/13/10/teaching-with-revealjs) by Luis Ibanez 

---

### Ende

  * &rarr; Anfang 
  * [Zur _ppp_-Startseite ](./index.html)

Version: 005, 2017-01-26

