# -*- coding: utf-8 -*-
#
"""
md2reveal.py

Version: 010

Date: 2017-01-12, W. Spiegel

Vers. 001: GUI, Test auf Markdown
Vers. 002: Generation of HTML-File
Vers. 003: Generation of Vertical Slide
Vers. 004: Feedback via Label im Fenster unten, Dokumentation, Pfad zu Reveal funktioniert, wird noch nicht benutzt . . .
Vers. 005: Notes, Tabellen via 'markdown.extensions.tables'
Vers. 006: json-Support, Generation via fileinput and filelist (instead of subprocess & cat)
Vers. 007: Button "TakeOver" übernimmt den Markdown-Dateinamen ohne die Extension für HTML-out
Vers. 008: md2reveal is using a simple template 'md2reveal.temp' in the subdirectory './template'
Vers. 009: function ausgabe modifiziert
Vers. 010: Neuer Seperator '-|-' zwischen unterschiedlichen vertikalen Sections, 'config.json' erweitert
- - - - 

Ein Programm mit ähnlicher Zielrichtung ist
reveal-ck, URL: https://github.com/jedcn/reveal-ck  (in Ruby)

- - - -
Use

* "---"  to separate slides

*  ".notes:"  for Notes

*  "|||" as a vertical seperator    
   Dieser Seperator muss VOR die Folie, vor der aus verzweigt wird!!!

* Underline with "=====" for title of presentation (=> title-tag)

See the file 'config.json'

For Python Markdown see https://pythonhosted.org/Markdown/
"""
#####################################################


_prg_ = "md2reveal"

_ver_ = "010"

_date_ = "2017-01-12"

import os.path
import sys
import os, struct, json
import subprocess,time,string,codecs
import webbrowser
import fileinput


def ausgabe(titel, text,_end_=False):   
    'Aufruf: ausgabe(text) bzw. ausgabe(text,t1)'
    if _end_:
        main = Tk() 
        main.withdraw()     
        tkMessageBox.showinfo(titel, text)    
        main.quit()
    else:
        tkMessageBox.showinfo(titel, text)


##def ausgabe(titel, text):   
##    'Aufruf: ausgabe(text) bzw. ausgabe(text,t1)'
##    tkMessageBox.showinfo(titel, text)    
###################################
md_flag = False
try:
    import markdown
    from markdown.extensions import toc
    from markdown.extensions import tables
    md_flag = True
except:
    #print "Markdown nicht installiert . . "
    ausgabe("No Markdown Support","Python-Markdown not installed . . ", _end_=True)
    

_toc_flag_ = 0

ret_toc  = None

ret_table = None

#_testenFlag_ = True
_testenFlag_ = False



_tkFlag_ = 1

root = None

try:
    from Tkinter import *
    import tkMessageBox
    from tkFileDialog import *
except:
    _tkFlag_ = 0

_idle_= 0


#####################################################
def beenden():
    if _tkFlag_:
        root.destroy()
        
    if not _idle_:
        import sys
        sys.exit(0)

def hilfe():  
    readme_doc = os.path.abspath( os.getcwd() ) + os.sep + 'docu' + os.sep +  "readme.html"
    webbrowser.open(readme_doc)

    

def takeOver():
    tmp = eingabe1.get()
    neuer_name = os.path.splitext(tmp)[0] + ".html"
    # ausgabe("takeOver",neuer_name)
    eingabe3.delete(0, END)
    eingabe3.insert(END,neuer_name)


def holeDateiname(choosed_entry,mode=1):    
    start_pfad = os.path.abspath (os.getcwd()) + os.sep        
    # multiple types in  askopenfilename via a tupel, see "html-Files" 
    if (mode==1): # html
	    eingabe = askopenfilename(title=u'Datei',filetypes=[("html-Files",("*.html","*.htm")),("md-Files","*.md"),("css-Files","*.css"),("txt-Files","*.txt"),("Alle Dateien","*.*")],initialdir=start_pfad)
    elif (mode==2): # md
	    eingabe = askopenfilename(title=u'Datei',filetypes=[("md-Files","*.md"),("html-Files",("*.html","*.htm")),("css-Files","*.css"),("txt-Files","*.txt"),("Alle Dateien","*.*")],initialdir=start_pfad)	
    elif (mode==3): # css		
	    eingabe = askopenfilename(title=u'Datei',filetypes=[("css-Files","*.css"),("md-Files","*.md"),("html-Files",("*.html","*.htm")),("css-Files","*.css"),("txt-Files","*.txt"),("Alle Dateien","*.*")],initialdir=start_pfad+'themes'+os.sep )		
    else:  # Default: html
	    eingabe = askopenfilename(title=u'Datei',filetypes=[("html-Files",("*.html","*.htm")),("md-Files","*.md"),("css-Files","*.css"),("txt-Files","*.txt"),("Alle Dateien","*.*")],initialdir=start_pfad)	
    if eingabe <> '': 
        dateiname  = os.path.abspath (eingabe)        
        choosed_entry.delete(0,END)         
        choosed_entry.insert(END, dateiname)

def getDir():
    import tkFileDialog
    _dir_ = tkFileDialog.askdirectory()
    eingabe2.delete(0,END)         
    eingabe2.insert(END, _dir_)
    

def getMDFile():
    """
        Reads the md-file and gives the content back
    """
    
    import codecs
    _md2reveal_dir_ = os.getcwd()
    _ok_ = False

    dateiname = os.path.abspath(eingabe1.get() )    # mf-File IN
    #print dateiname
    datei = codecs.open(dateiname, "r", "utf-8")
    try:
        data = datei.read()
        # print data
        datei.close()
        _ok_ = True
    except:
        datei.close()
        
    if _ok_:
        return data
    else:
        return ''

def printHead():
    print
    print "----------------------------------------------"
    print
    print ">>> Read Markdown-File '" + os.path.basename(eingabe1.get()) + "'"
    print

def buildDependencies():    
    """
				math: {
					// mathjax: 'http://cdn.mathjax.org/mathjax/latest/MathJax.js',
					config: 'TeX-AMS_HTML-full'
				},
				dependencies: [
					// ... 
	  
					{ src: 'plugin/menu/menu.js' }
				]

    """
    
    # withMath        
    withMath = False
    mathVar = ret_math.get()
    if (mathVar==1):
        withMath = True
    #print withMath
    
    # withMenu
    withMenu = False
    menuVar = ret_menu.get()
    if (menuVar==1):
        withMenu = True
    #print withMenu
    _dep_ = ""
    if (withMath and withMenu):    
        _dep_ = """				math: {
					// mathjax: 'http://cdn.mathjax.org/mathjax/latest/MathJax.js',
					config: 'TeX-AMS_HTML-full'
				},
				dependencies: [ 
					{ src: 'lib/js/classList.js' },
					{ src: 'plugin/notes/notes.js' },					
					{ src: 'plugin/math/math.js', async: true },
					{ src: 'plugin/menu/menu.js' }
				]"""
    elif (withMath):
        _dep_ = """				math: {
					// mathjax: 'http://cdn.mathjax.org/mathjax/latest/MathJax.js',
					config: 'TeX-AMS_HTML-full'
				},
				dependencies: [ 
					{ src: 'lib/js/classList.js' },
					{ src: 'plugin/notes/notes.js' },					
					{ src: 'plugin/math/math.js', async: true }
				]"""
        
    elif (withMenu):
        _dep_ = """				dependencies: [
					{ src: 'lib/js/classList.js' },
					{ src: 'plugin/notes/notes.js' },
					{ src: 'plugin/menu/menu.js' }
				]"""
    else:
        _dep_ = """				dependencies: [
					{ src: 'lib/js/classList.js' },
					{ src: 'plugin/notes/notes.js' }
				]"""

    #print _dep_            
    return _dep_

def htmlNoteSection(eingabe,note):
    return '\n<section data-transition="convex">\n    ' + eingabe +  '\n<aside  class="notes">\n    ' + note + "\n</aside>\n" + "\n</section>\n"


def htmlNote(note):
    return '\n<aside  class="notes">\n    ' + note + "\n</aside>\n"

def htmlVertical(eingabe):
    return '\n<section>\n    ' + eingabe + "\n</section>\n"


def htmlSection(eingabe):
    return '\n<section data-transition="convex">\n    ' + eingabe + "\n</section>\n"

    
def md2reveal():
    """
        Transforms a md-file into a reveal-compatible html-file
    """
##    ppp_dir = eingabe2.get()
##    if not os.path.isdir(ppp_dir):
##        if len(ppp_dir) < 1:
##            ppp_dir = os.getcwd()
##    #print ppp_dir

    _ok_ = False
    
    configFile = "." + os.sep + "config.json"
    try:
        json_data=open(configFile).read()
        confDici = json.loads(json_data)
        
        if confDici.has_key("sepSlide"):
            sepSlide = confDici["sepSlide"]
        else:  # Default-Wert
            sepSlide = "---"
        
        if confDici.has_key("slideNote"):
            slideNote = confDici["slideNote"]
        else:  # Default-Wert
            slideNote = ".notes:"
            
        
        if confDici.has_key("verSlide"):
            verSlide = confDici["verSlide"]
        else:  # Default-Wert
            verSlide = "|||"
        
        if confDici.has_key("sepVerSlide"):
            sepVerSlide = confDici["sepVerSlide"]
        else:  # Default-Wert
            sepVerSlide = "-|-"
                        
        
        if confDici.has_key("htmlTitle"):
            htmlTitle = confDici["htmlTitle"]
        else:  # Default-Wert
            htmlTitle = "==="

        if confDici.has_key("templateFileName"):            
            templateFileName = confDici["templateFileName"]
        else:  # Default-Wert
            templateFileName = "md2reval.temp"

        #print confDici
        print "Markdown - Extensions used by md2reveal (from 'config.json')"    
        for eintrag in confDici:
            print eintrag + ': "' + confDici[eintrag]  + '"'
            
    except:  # Default-Werte
        # Markdown - Extensions        
        sepSlide  = "---"      #  slide-separator
        slideNote = ".notes:"  #  Notes
        #slideNote = "Note:"   #  for "simple05.md"
        sepVerSlide = "-|-"    #  seperate vertical sections    
        verSlide  = "|||"      #  vertical seperator; 
        htmlTitle = "==="      #  presentation title  (=> title-tag)
        templateFileName = "md2reval.temp"


    data = getMDFile()
    lastLine = ''
    #nextLine = ''
    testLine = ''

    
    if md_flag and (len(data) > 0):
        printHead()
        
        #print data
        listData = data.split('\n')
        _max_ = len(listData)
        lastLine = testLine = listData[0]
        zaehler = 0
        buildSlide = ''
        _slide_ = ''
        presentationTitle = ''
        _vertical_ = False
        
        for line in listData:
            testLine = line
            if (testLine.find(sepSlide) > -1) and (testLine.find(sepSlide) < 2):
                
                html = markdown.markdown(buildSlide, extensions=['markdown.extensions.tables'])

                if _vertical_:
                    _vertical_ = False
                    _slide_  = _slide_  + htmlSection( html )  + '\n</section>\n'
                else:	
                    _slide_  = _slide_ + htmlSection( html )

                buildSlide = ''
            elif (testLine.find(slideNote) > -1) and (testLine.find(slideNote) < 2):
                _note_ = testLine.lstrip(slideNote)
                buildSlide = buildSlide + htmlNote( _note_ )

            elif (testLine.find(verSlide) > -1) and (testLine.find(verSlide) < 2):
                html = markdown.markdown(buildSlide, extensions=['markdown.extensions.tables'])
                if _vertical_:  # wir sind schon im vertikal-Modus . . .
                    _slide_  = _slide_  + htmlSection( html )
                else:
                    if len(html) > 0:
                        _slide_  = _slide_  + htmlSection( html )  + "\n<section>\n"
                    else:
                        _slide_  = _slide_  + "\n<section>\n"
                        
                buildSlide = ''
                _vertical_ = True
                
            elif (testLine.find(sepVerSlide) > -1) and (testLine.find(sepVerSlide) < 2):
                html = markdown.markdown(buildSlide, extensions=['markdown.extensions.tables'])
                if _vertical_:  # wir sind schon im vertikal-Modus . . .
                    _slide_  = _slide_  + htmlSection( html ) + "\n</section>\n\n\n<section>\n" 
                    #print htmlSection( html )
                else: # >>> dieser Fall sollte nicht eintreten!
                    print "Syntax Error!"
                    #print "Dieser Fall sollte nicht eintreten!"                    
                    
                buildSlide = ''
                #_vertical_ = True  # Wir sind & bleiben im Vertikal-Modus
                
            elif (testLine.find(htmlTitle) > -1) and (testLine.find(htmlTitle) < 2):
                _title_ = lastLine.strip()
                buildSlide = ''

            else:
                buildSlide = buildSlide + testLine + '\n'
                
            lastLine = testLine

                
        if len(buildSlide) > 0:
            html = markdown.markdown(buildSlide, extensions=['markdown.extensions.tables'])
            _slide_  = _slide_ + htmlSection( html )
            if _vertical_:
                _slide_  = _slide_ + '\n</section>\n'            

        _dep_ = buildDependencies()
        
        if len(_dep_) > 0:
            #time.sleep(0.1) # Pause
            templatePath = os.path.abspath (os.getcwd()) + os.sep + "template" + os.sep    
            templateFile = codecs.open(templatePath + templateFileName,"r", "utf-8")
            # Template Variables:  _title_, _slide_ and _dep_

            htmlOut = os.path.abspath(eingabe3.get() )   # HTML-File html-Out
            try: # generate Reveal-HTML File

                revealPresentation = ''
                ## >>>  Template funktionieren nur zeilenweise!!!
                for line in templateFile:
                    tLine = string.Template(line)
                    revealPresentation = revealPresentation + tLine.substitute(sitetitle=_title_, md2reveal_content=_slide_,dependencies=_dep_)
            
                templateFile.close()
                              
                _ok_ = True                        
               
            except:
                #_ok_ = False
                templateFile.close()
                
            if _ok_:            
                fout = codecs.open(htmlOut, 'w', "utf-8")
                fout.write(revealPresentation)                    
                fout.close()
                time.sleep(0.1) # Pause
                lab4var.set("HTML-File generated: >" + str(htmlOut) + "<")
                webbrowser.open( htmlOut)
            else:
                lab4var.set("Generation of Reveal-File >" + str(htmlOut) + "< failed!")     
        else:
            lab4var.set("Generation of Reveal-File >" + str(htmlOut) + "< failed!")

      
#######################################################
#######################################################        
# main   
if __name__ == "__main__":   
    if _tkFlag_:
        _debug_ = 0
        
        root=Tk()
        root.withdraw()        
        root.title(_prg_ + ", Vers. " + _ver_)

        foben = Frame(root)
        foben.pack(expand=YES, fill=BOTH)  

        lab1=Label(foben,text=u"Markdown in: ")
        lab1.grid(row=1,column=0)
        eingabe1 = Entry(foben,width=73)             ## Eingabezeile erzeugen
        eingabe1.grid(row=1,column=1)
        #eingabe1.insert(END,'in.md')
        eingabe1.insert(END,'./examples/simple_sp.md')
        fileButton1 = Button(foben,text=" _open_ ",bd="1",command=(lambda arg=eingabe1: holeDateiname(arg,2) )  )
        fileButton1.grid(row=1,column=2)
      
    ##    lab0=Label(foben,text=u"Titel:       ") 
    ##    lab1=Label(foben,text=u"Markdown in: ")
    ##    lab2=Label(foben,text=u"CSS-Datei:   ")
        lab3=Label(foben,text=u"HTML out:      ")
        lab3.grid(row=3,column=0)
        eingabe3 = Entry(foben,width=73)             ## Eingabezeile erzeugen
        eingabe3.grid(row=3,column=1)
        eingabe3.insert(END,'./examples/reveal_out.html')
        fileButton3 = Button(foben,text=" _open_ ",bd="1",command=(lambda arg=eingabe3: holeDateiname(arg) )  )
        fileButton3.grid(row=3,column=2)



        funten = Frame(root)
        funten.pack(expand=YES, fill=BOTH)
        generateHTMLBut=Button(funten,text="-> reveal",command=md2reveal)
        generateHTMLBut.pack(side=LEFT,fill=X,expand=YES)
        
        #funten2 = Frame(funten,bd=1, relief=GROOVE)
        funten2 = Frame(funten,bd=1, relief=RAISED)
        funten2.pack(side=LEFT,fill=X,expand=YES)
        
        math_lab=Label(funten2,text=u" >> MathJax <<  ",fg="red")
        #math_lab.pack(side=LEFT,fill=X,expand=YES)
        math_lab.grid(row=0,column=0)
        ret_math = IntVar(root)    
        mathButton=Checkbutton(funten2,variable=ret_math)
        #mathButton.pack(side=LEFT,fill=X,expand=YES)
        mathButton.grid(row=0,column=1)
        
        menu_lab=Label(funten2,text=u"  >> Menu <<  ",fg="red")
        #menu_lab.pack(side=LEFT,fill=X,expand=YES)
        menu_lab.grid(row=0,column=2)
        ret_menu = IntVar(root)
        ret_menu.set(1)
        menuButton=Checkbutton(funten2,variable=ret_menu)
        #menuButton.pack(side=LEFT,fill=X,expand=YES)
        menuButton.grid(row=0,column=3)
        

        toBut=Button(funten,text="_in2out_",command=takeOver)
        toBut.pack(side=LEFT,fill=X,expand=YES)

        helpbut=Button(funten,text="Help",command=hilfe)
        helpbut.pack(side=LEFT,fill=X,expand=YES)

        endbut=Button(funten,text="Exit",command=beenden)
        endbut.pack(side=RIGHT,fill=X,expand=YES)      
        funten2 = Frame(root)
        funten2.pack(expand=YES, fill=BOTH)
        lab4var = StringVar()
        lab4=Label(funten2,textvariable=lab4var,font=("Helvetica", 8),anchor=W )
        lab4.pack(fill=X,expand=YES)

        root.deiconify()  # Unhide md2reveal                                
        root.mainloop()
    else:
        print ">>> No TKinter installed!\n\n\tmd2reveal.py will not work. Sorry!"
